function [rawhdr,DetectedFormat]=readrawhdr(hdrFile,MachineFormat)
%[rawhdr,DetectedFormat]=readrawhdr(hdrFile,MachineFormat)
%read '.hdr' file
%Input:
% hdrFile: a *.hdr file
% MachineFormat: specify 'ieee-be' or 'ieee-le';%optional
%Output:
% rawhdr: struct rawhdr
% DetectedFormat: 'ieee-be' or 'ieee-le'
%
%20040318, jdlee
%

%check input paramters
if(nargin<1),
  error('no input filename');    
end

hdrFile = ext_img2hdr(hdrFile);

DetectedFormat = hdrbyteorder(hdrFile);

if(nargin<2),
    MachineFormat = DetectedFormat;
elseif (~strcmp(DetectedFormat,MachineFormat)),
    error('specified machineformat is different from detected machine format.');
end

rawhdr.byte_order = DetectedFormat;
%----------------------------------------------------------------------

fid = fopen(hdrFile,'rb',MachineFormat);

%read hdr file---------------------------------------------
%read struct header_key
rawhdr.hk.sizeof_hdr    = fread(fid,1,'int32');
rawhdr.hk.data_type     = char(fread(fid,10,'uchar'))';
rawhdr.hk.db_name       = char(fread(fid,18,'uchar'))';
rawhdr.hk.extents       = fread(fid,1,'int32');
rawhdr.hk.session_error = fread(fid,1,'int16');
rawhdr.hk.regular       = char(fread(fid,1,'uchar'));
rawhdr.hk.hkey_un0      = char(fread(fid,1,'uchar'));

%read struct image_dimension
rawhdr.dime.dim        = fread(fid,8,'int16');
rawhdr.dime.vox_units  = char(fread(fid,4,'uchar'))';
rawhdr.dime.cal_units  = char(fread(fid,8,'uchar'))';
rawhdr.dime.unused14   = fread(fid,1,'int16');
rawhdr.dime.datatype   = fread(fid,1,'int16');
rawhdr.dime.bitpix	   = fread(fid,1,'int16');
rawhdr.dime.dim_un0	   = fread(fid,1,'int16');
rawhdr.dime.pixdim	   = fread(fid,8,'float');
rawhdr.dime.vox_offset = fread(fid,1,'float');
rawhdr.dime.funused1   = fread(fid,1,'float');%SCALE in spm
rawhdr.dime.funused2   = fread(fid,1,'float');
rawhdr.dime.funused3   = fread(fid,1,'float');
rawhdr.dime.cal_max    = fread(fid,1,'float');
rawhdr.dime.cal_min	   = fread(fid,1,'float');
rawhdr.dime.compressed = fread(fid,1,'int32');%?float or int32
rawhdr.dime.verified   = fread(fid,1,'int32');%?float or int32
rawhdr.dime.glmax	   = fread(fid,1,'int32');
rawhdr.dime.glmin	   = fread(fid,1,'int32');

%read struct data_history
rawhdr.hist.descrip	     = char(fread(fid,80,'uchar'))';
rawhdr.hist.aux_file	 = char(fread(fid,24,'uchar'))';
rawhdr.hist.orient		 = fread(fid,1,'uchar');
rawhdr.hist.origin	 	 = fread(fid,5,'int16'); %spm-specific
rawhdr.hist.generated	 = char(fread(fid,10,'uchar'))';
rawhdr.hist.scannum	     = char(fread(fid,10,'uchar'))';
rawhdr.hist.patient_id	 = char(fread(fid,10,'uchar'))';
rawhdr.hist.exp_date	 = char(fread(fid,10,'uchar'))';
rawhdr.hist.exp_time	 = char(fread(fid,10,'uchar'))';
rawhdr.hist.hist_un0	 = char(fread(fid,3,'uchar'))';
rawhdr.hist.views		 = fread(fid,1,'int32');
rawhdr.hist.vols_added	 = fread(fid,1,'int32');
rawhdr.hist.start_field  = fread(fid,1,'int32');
rawhdr.hist.field_skip	 = fread(fid,1,'int32');
rawhdr.hist.omax		 = fread(fid,1,'int32');
rawhdr.hist.omin		 = fread(fid,1,'int32');
rawhdr.hist.smax		 = fread(fid,1,'int32');
rawhdr.hist.smin		 = fread(fid,1,'int32');
%end of reading hdr file -------------------------------------

fclose(fid);

return